package org.msh.tb.cases.summary;

import org.msh.etbm.commons.Item;
import org.msh.tb.entities.enums.DstResult;
import org.msh.tb.workspaces.customizable.WorkspaceCustomizationService;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 5/2/17.
 */
public class SummaryRow {


    private int month;

    private String monthDisplay;

    private List<MicroscopySummary> microscopyResults = new ArrayList<MicroscopySummary>();

    private List<XpertSummary> xpertResults = new ArrayList<XpertSummary>();

    private List<WeightSummary> weights = new ArrayList<WeightSummary>();

    private List<Item<String>> medicines = new ArrayList<Item<String>>();

    private List<DSTSummary> dstResults = new ArrayList<DSTSummary>();

    /**
     * Return true if medicine is prescribed for this month of treatment
     * @param med
     * @return
     */
    public boolean isMedicinePrescribed(Item<String> med) {
        return medicines.contains(med);
    }

    /**
     * Return the result of the DST for the given medicine
     * @param med
     * @return
     */
    public DstResult getDstResult(Item<String> med) {
        DSTSummary res = dstResultByMedicine(med.getId());

        return res != null ? res.getResult() : DstResult.NOTDONE;
    }

    /**
     * Search for a DST information result by its medicine name
     * @param med
     * @return
     */
    public DSTSummary dstResultByMedicine(String med) {
        for (DSTSummary res: dstResults) {
            if (res.getMedicine().equals(med)) {
                return res;
            }
        }
        return null;
    }

    public int getMonth() {
        return month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public List<MicroscopySummary> getMicroscopyResults() {
        return microscopyResults;
    }


    public List<XpertSummary> getXpertResults() {
        return xpertResults;
    }

    public List<WeightSummary> getWeights() {
        return weights;
    }

    public List<Item<String>> getMedicines() {
        return medicines;
    }

    public String getMonthDisplay() {
        return monthDisplay;
    }

    public void setMonthDisplay(String monthDisplay) {
        this.monthDisplay = monthDisplay;
    }

    public List<DSTSummary> getDstResults() {
        return dstResults;
    }

}
